using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace cifXTest
{
    public partial class cifXChannelInfo : Form
    {
        private cifXUser cifXUser = new cifXUser();
        private cifxBase cifXBase = new cifxBase();

        public cifXChannelInfo()
        {
            InitializeComponent();
        }

        private void cifXTest_FormClosed(object sender, FormClosedEventArgs e)
        {
            cifXUser.xDriverClose();
        }

        private void cmbInfoSelect_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.lstList.BeginUpdate();
            this.lstList.Items.Clear();

            switch (this.cmbInfoSelect.SelectedItem.ToString())
            {
                case "Generic Information":
                    GetGenericInformation();
                    break;
                case "Info Block":
                    GetInfoBlock();
                    break;
                case "Channel Block":
                    GetChannelBlock();
                    break;
                case "Control Block":
                    GetControlBlock();
                    break;
                case "Status Block":
                    GetStatusBlock();
                    break;
                case "I/O Information":
                    GetIOInformation();
                    break;
            }
            this.lstList.EndUpdate();
        }

        private void GetIOInformation()
        {
            UInt32 lret = 0;
            UInt32 ulAereaInCnt     = cifXUser.ChannelInformation.ulIOInAreaCnt;
            UInt32 ulAereaOutCnt    = cifXUser.ChannelInformation.ulIOOutAreaCnt;

            this.lstList.BeginUpdate();
            this.lstList.Items.Clear();

            for (int i = 0; i < ulAereaInCnt; i++)
            {
                lret = cifXUser.xChannelIOInfo(cifXUser.CIFX_IO_INPUT_AREA, (UInt32)i);
                this.txtError.Text = cifXBase.SetLastError(lret);
                this.lstList.Items.Add(new ListViewItem(new string[] { "I/O Input Aerea " + i, "----------------"}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Size", cifXUser.ChannelIOInformation.ulTotalSize.ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Used Size", cifXUser.ChannelIOInformation.ulUsedSize.ToString() }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "I/O Mode", cifXUser.ChannelIOInformation.ulIOMode.ToString() }));
            }
            for (int i = 0; i < ulAereaOutCnt; i++)
            {
                lret = cifXUser.xChannelIOInfo(cifXUser.CIFX_IO_OUTPUT_AREA, (UInt32)i);
                this.txtError.Text = cifXBase.SetLastError(lret);
                this.lstList.Items.Add(new ListViewItem(new string[] { "I/O Output Aerea " + i, "----------------" }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Size", cifXUser.ChannelIOInformation.ulTotalSize.ToString() }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Used Size", cifXUser.ChannelIOInformation.ulUsedSize.ToString() }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "I/O Mode", cifXUser.ChannelIOInformation.ulIOMode.ToString() }));
            }
            this.lstList.EndUpdate();
        }

        private void GetGenericInformation()
        {
            UInt32 lret = 0;
            if (cifXUser.hChannel != 0)
            {
                //Read Channel Information
                lret = cifXUser.xChannelInfo();
                if (lret == 0)
                {
                    //print the channel information to the list
                    string sFWVersion = string.Format("{0:d}.{1:d}.{3:d}.{2:d} (Build {3:d})",
                                                                    cifXUser.ChannelInformation.usFWMajor,
                                                                    cifXUser.ChannelInformation.usFWMinor,
                                                                    cifXUser.ChannelInformation.usFWRevision,
                                                                    cifXUser.ChannelInformation.usFWBuild);
                    string sFWDate      = string.Format("{1:d}/{0:d}/{2:d}",
                                                                    cifXUser.ChannelInformation.bFWDay,
                                                                    cifXUser.ChannelInformation.bFWMonth,
                                                                    cifXUser.ChannelInformation.usFWYear);            

                    this.lstList.Items.Add(new ListViewItem(new string[] { "Board Name", cifXBase.ByteArrayToString(cifXUser.ChannelInformation.abBoardName)}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Board Alias",cifXBase.ByteArrayToString(cifXUser.ChannelInformation.abBoardAlias) }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Device Number", cifXUser.ChannelInformation.ulDeviceNumber.ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Serial Number", cifXUser.ChannelInformation.ulSerialNumber.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Firmware Name", cifXBase.ByteArrayToString(cifXUser.ChannelInformation.abFWName) }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Firmware Version", sFWVersion }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Firmware Date", sFWDate }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Channel Error", string.Format("0x{0:X8}",cifXUser.ChannelInformation.ulChannelError) }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Open Count", cifXUser.ChannelInformation.ulOpenCnt.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Put Packet Count", cifXUser.ChannelInformation.ulPutPacketCnt.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Get Packet Count", cifXUser.ChannelInformation.ulGetPacketCnt.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Size", cifXUser.ChannelInformation.ulMailboxSize.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "I/O Input Area Count", cifXUser.ChannelInformation.ulIOInAreaCnt.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "I/O Output Area Count", cifXUser.ChannelInformation.ulIOOutAreaCnt.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Handshake Size", cifXUser.ChannelInformation.ulHskSize.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "netX Status Flags", string.Format("0x{0:X8}",cifXUser.ChannelInformation.ulNetxFlags) }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Host Status Flags", string.Format("0x{0:X8}",cifXUser.ChannelInformation.ulHostFlags) }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Host COS Flags", string.Format("0x{0:X8}",cifXUser.ChannelInformation.ulHostCOSFlags) }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Device COS Flags", string.Format("0x{0:X8}",cifXUser.ChannelInformation.ulDeviceCOSFlags) }));
                }
                else
                    this.txtError.Text = cifXBase.SetLastError(lret);
            }
            else
            {
                lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_INFORMATION);
                if (lret == 0)
                {
                    this.lstList.Items.Add(new ListViewItem(new string[] { "System Error", string.Format("0x{0:X8}", 
                                                                            cifXUser.SystemChannelInformation.ulSystemError )}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "DPM Total Size", 
                                                                            cifXUser.SystemChannelInformation.ulDpmTotalSize.ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Size", 
                                                                            cifXUser.SystemChannelInformation.ulMBXSize.ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Device Number", 
                                                                            cifXUser.SystemChannelInformation.ulDeviceNumber.ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Serial Number", 
                                                                            cifXUser.SystemChannelInformation.ulSerialNumber.ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Open Count", 
                                                                            cifXUser.SystemChannelInformation.ulOpenCnt.ToString()}));
                    this.txtError.Text = cifXBase.SetLastError(lret);
                }
                else
                    this.txtError.Text = cifXBase.SetLastError(lret);
            }
        }

        private void GetInfoBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_INFO_BLOCK);
            if (lret == 0)
            {
                this.lstList.Items.Add(new ListViewItem(new string[] { "Cookie", 
                                                                            cifXBase.ByteArrayToString(                                                    
                                                                            cifXUser.SystemchannelSystemInfoBlock.abCookie )
                                                                         }));
                this.lstList.Items.Add(new ListViewItem(new string[] { "DPM Total Size", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulDpmTotalSize.ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Device Number", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulDeviceNumber.ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Serial Number", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulSerialNumber.ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[0]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[0])}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[1]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[1])}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[2]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[2])}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "HW Option[3]", string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ausHwOptions[3])}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Manufacturer",      string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usManufacturer)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Production Date",   string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usProductionDate)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "License Flags 1",   string.Format("0x{0:X8}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulLicenseFlags1)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "License Flags 2",   string.Format("0x{0:X8}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.ulLicenseFlags2)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "netX License ID",   string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usNetxLicenseID)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "netX License Flags",string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usNetxLicenseFlags)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Device Class",      string.Format("0x{0:X4}",
                                                                            cifXUser.SystemchannelSystemInfoBlock.usDeviceClass)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "HW Revision", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.bHwRevision.ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "HW Compatibility", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.bHwCompatibility.ToString()}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Device ID", 
                                                                            cifXUser.SystemchannelSystemInfoBlock.bDevIdNumber.ToString()}));
                this.txtError.Text = cifXBase.SetLastError(lret);
            }
            else
                this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private void GetChannelBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_CHANNEL_BLOCK);
            if(lret == 0)
            {
                for (int iChannelDefinition = 0; iChannelDefinition <= cifXUser.CIFX_MAX_NUMBER_OF_CHANNEL_DEFINITION - 1; iChannelDefinition++)
                {
                    byte[] SizeOfChannel = new byte[4]{ cifXUser.abInfoBlock[iChannelDefinition, 4],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 5],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 6],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 7]};

                    byte[] MailboxOffset = new byte[2] { cifXUser.abInfoBlock[iChannelDefinition, 10],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 11]};

                    byte[] MailboxSize = new byte[2] { cifXUser.abInfoBlock[iChannelDefinition, 8],
                                                        cifXUser.abInfoBlock[iChannelDefinition, 9]};

                    this.lstList.Items.Add(new ListViewItem(new string[] { "Channel " + iChannelDefinition.ToString(),
                                                                       "--------------" }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Type" , GetChannelType(cifXUser.abInfoBlock[iChannelDefinition,0])
                                                                       }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Number of Blocks" ,
                                                                       cifXUser.abInfoBlock[iChannelDefinition, 3].ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Size of Channel" ,
                                                                       BitConverter.ToInt32(SizeOfChannel, 0).ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Start Offset" ,
                                                                       BitConverter.ToInt16(MailboxOffset, 0).ToString() }));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Mailbox Size" ,
                                                                       BitConverter.ToInt16(MailboxSize, 0).ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Handshake Width" ,
                                                                       cifXUser.abInfoBlock[iChannelDefinition, 2].ToString()}));
                    this.lstList.Items.Add(new ListViewItem(new string[] { "Handshake Pos" ,
                                                                       cifXUser.abInfoBlock[iChannelDefinition, 2].ToString() }));
                    this.txtError.Text = cifXBase.SetLastError(lret);
                }
            }
            else
                this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private string GetChannelType(byte bCHType)
        {
            switch (bCHType)
            {
                case 0x00:
                    return "UNDEFINED";
                case 0x01:
                    return "NOT AVAILABLE";
                case 0x02:
                    return "RESERVED";
                case 0x03:
                    return "SYSTEM";
                case 0x04:
                    return "HANDSHAKE";
                case 0x05:
                    return "COMMUNICATION";
                case 0x06:
                    return "APPLICATION";
            }
            return "RESERVED";
        }

        private void GetControlBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_CONTROL_BLOCK);
            if (lret == 0)
            {
                this.lstList.Items.Add(new ListViewItem(new string[] { "System Command COS", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemControlBlock.ulSystemCommandCOS )}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "Reserved", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemControlBlock.ulReserved )}));
                this.txtError.Text = cifXBase.SetLastError(lret);
            }
            else
                this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private void GetStatusBlock()
        {
            UInt32 lret = 0;

            lret = cifXUser.xSysdeviceInfo(cifXUser.CIFX_INFO_CMD_SYSTEM_STATUS_BLOCK);
            if (lret == 0)
            {
                double  dCPU    = cifXUser.SystemChannelSystemStatusBlock.usCpuLoad;
                int     iSecond = (int)cifXUser.SystemChannelSystemStatusBlock.ulTimeSinceStart;
                int     iDay    = iSecond / 86400;
                int     iHour   = (iSecond - (iDay * 86400)) / 3600;
                int     iMinute = (iSecond - (iDay * 86400) - (iHour * 3600)) / 60;
                int     iSec    = (iSecond - (iDay * 86400) - (iHour * 3600) - (iMinute * 60));   
                

                this.lstList.Items.Add(new ListViewItem(new string[] { "System COS", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulSystemCOS)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "System Status", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulSystemStatus)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "System Error", string.Format("0x{0:X8}",
                                                                            cifXUser.SystemChannelSystemStatusBlock.ulSystemError)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "System Start Time [s]", string.Format("{0:d} ({1:d}d {2:d2}:{3:d2}:{4:d2})",
                                                                            iSecond,iDay,iHour,iMinute, iSec)}));
                this.lstList.Items.Add(new ListViewItem(new string[] { "System CPU Load [%]", string.Format("{0:F2}",
                                                                            dCPU/100)}));
                this.txtError.Text = cifXBase.SetLastError(lret);
            }
            else
                this.txtError.Text = cifXBase.SetLastError(lret);
        }

        private void btnUpdate_Click(object sender, EventArgs e)
        {
            this.lstList.BeginUpdate();
            this.lstList.Items.Clear();

            switch (this.cmbInfoSelect.SelectedItem.ToString())
            {
                case "Generic Information":
                    GetGenericInformation();
                    break;
                case "Info Block":
                    GetInfoBlock();
                    break;
                case "Channel Block":
                    GetChannelBlock();
                    break;
                case "Control Block":
                    GetControlBlock();
                    break;
                case "Status Block":
                    GetStatusBlock();
                    break;
                case "I/O Information":
                    GetIOInformation();
                    break;
            }
            this.lstList.EndUpdate();
        }

        private void cifXChannelInfo_Load(object sender, EventArgs e)
        {
            /* If only the Device is opened you have the following possible selections
             * Generic Information
             * Info Block
             * Channel Block
             * Control Block
             * Status Block
             * --------------------------
             * If a channel is opened the following choices are available
             * Generic Information
             * I/O Information
             */

            this.cmbInfoSelect.BeginUpdate();
            this.cmbInfoSelect.Items.Clear();

            if (cifXUser.hChannel != 0)
            {
                this.cmbInfoSelect.Items.Add("Generic Information");
                this.cmbInfoSelect.Items.Add("I/O Information");
                this.cmbInfoSelect.SelectedIndex = 0;
            }
            else
            {
                this.cmbInfoSelect.Items.Add("Generic Information");
                this.cmbInfoSelect.Items.Add("Info Block");
                this.cmbInfoSelect.Items.Add("Channel Block");
                this.cmbInfoSelect.Items.Add("Control Block");
                this.cmbInfoSelect.Items.Add("Status Block");
                this.cmbInfoSelect.SelectedIndex = 0;
            }
            this.cmbInfoSelect.EndUpdate();
        }
    }
}